import AppContext from '@/context/AppContext'
import React, { useContext } from 'react'
import OrgSelector from '../OrgSelector'
import { useSession } from 'next-auth/react'

const CheckActiveOrg = (props) => {

    const context = useContext(AppContext)
    const { status, update } = useSession();

    // Function to retrieve active organization from localStorage
    const getActiveOrgFromLS = () => {
        const activeOrgId = localStorage.getItem('activeOrg');
        if (activeOrgId) {
            const org = context.orgList.find(org => org._id === activeOrgId);
            if (org) {
                return org;
            } else {
                // If the organization is not found, remove it from localStorage
                localStorage.removeItem('activeOrg');
            }
        }
        return null;
    };

    // Function to refresh user access in session
    const refreshUserAccess = async () => {
        await update();
    }

    if(context.activeOrg && context.activeOrg._id){
        // If activeOrg is set, return the children components
        // This means the user has an active organization selected
        return (
            <>
                {props.children}
            </>
        )
    } else{
        // If activeOrg is not set, handle the case where the user needs to select an organization
        // 1. Check if activeOrg is set in localStorage
        const activeOrgFromLS = getActiveOrgFromLS();
        if(activeOrgFromLS){
            // If an organization is found in localStorage, set it as the active organization
            context.setActiveOrg(activeOrgFromLS);
            refreshUserAccess(); // Refresh user access to ensure the session is updated
            // Return the children components as the active organization is now set
            // This means the user has an active organization selected
            // and can access the application
            return (
                <>
                    {props.children}
                </>
            )
        }
        // 2. If org list is not empty, set the first organization as activeOrg
        // This will allow the user to access the application with the first organization
        if(context?.orgList && context?.orgList?.length > 0){
            // Set the first organization in the list as the active organization
            context.setActiveOrg(context.orgList[0]);
            refreshUserAccess(); // Refresh user access to ensure the session is updated
            // Return the children components as the active organization is now set
            // This means the user has an active organization selected
            return (
                <>
                    {props.children}
                </>
            )
        }
        // 3. If no activeOrg is set, show the OrgSelector component
        // This will allow the user to select an organization
        context.setActiveOrg(null); // Clear any existing active organization
        // Show the OrgSelector component to let the user select an organization
        // This component will handle the organization selection and set the activeOrg in context
        // and localStorage

        return <OrgSelector />
    }
}

export default CheckActiveOrg