import { useSession } from 'next-auth/react';
import { useRouter } from 'next/router';
import React, { useContext, useEffect, useState } from 'react'
import Loading from '../Loading';
import AppContext from '@/context/AppContext';
import { message } from 'antd';

const CheckUserAccess = (props) => {
    const [messageApi, contextHolder] = message.useMessage();
    const router = useRouter();
    const { status, data, update } = useSession();
    
    const context = useContext(AppContext)

    useEffect(() => {
        const fetchDetails = async () => {
            try{
                const response = await fetch('/api/users/getaccess',
                {
                    method: 'POST',
                    headers: {
                    'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({})
                })

                const result = await response.json()

                if(result.status === 'success' && result.result){
                    const userInfo = result?.result?.user || {};
                    const orgList = result?.result?.organizations || [];
                    context.setUserInfo(userInfo) // Set user info (name, email, profilepik,...) in context
                    context.setOrgList(orgList)
                    return;
                }
                messageApi.open({
                    type: 'error',
                    content: 'Error while fetching user access!',
                });
            }catch(err){
                console.log(err)
                messageApi.open({
                    type: 'error',
                    content: 'Error while fetching user access!',
                });
            }
        }

        if(status === 'authenticated' && !Object.keys(context.userInfo).length){
            fetchDetails();
            
        }
    }, [status]);

    if(context.userInfo && Object.keys(context.userInfo).length){
        return(
            <>
                {contextHolder}
                {props.children}
            </>
        )
    }
    if(status === 'unauthenticated'){
        return(
            <>
                {contextHolder}
                {props.children}
            </>
        )
    }
    return (
        <Loading isLoading={true}/>
    )
}

export default CheckUserAccess