import { message } from 'antd';
import { signIn, signOut, useSession } from 'next-auth/react';
import { useRouter } from 'next/router';
import { useEffect, useState } from 'react';
import { FcGoogle } from "react-icons/fc";

function GoogleSignInButton() {
  const { data: session } = useSession();
  const [isGoogleLoaded, setIsGoogleLoaded] = useState(false);
  const router = useRouter();

//   useEffect(() => {
//     if (!session && typeof window !== 'undefined' && window.google && !isGoogleLoaded) {
//       console.log('Google object is available');
      
//       google.accounts.id.initialize({
//         client_id: process.env.NEXT_PUBLIC_GOOGLE_CLIENT_ID,
//         callback: handleCredentialResponse,
//       });
      
//       google.accounts.id.prompt();
//       setIsGoogleLoaded(true);
//     }
//   }, [session, isGoogleLoaded]);

//   const handleCredentialResponse = (response) => {
//     signIn('google', { id_token: response.credential });
//   };

  const signInGoogle = async () => {
    try{
        const res = await signIn('google', {
            callbackUrl: '/dashboard',
            redirect: false,
          })

        if (res?.error) {
            console.error('Google Sign-In Error:', res.error);
            message.error('Failed to sign in with Google. Please try again.');
        }
    }catch(err){
        console.log(err)
    }
  }

  return (
    <button className='google_signin' onClick={() => signInGoogle()}><FcGoogle /> <span>Continue with Google</span></button>
  );
}

export default GoogleSignInButton;