import withAuth from '@/components/auth/withAuth';
import DashboardLayout from '@/components/layout/DashboardLayout';
import PageLoading from '@/components/utils/PageLoading';
import { Button, Col, Result, Row } from 'antd';
import Head from 'next/head';
import React from 'react'

const RestrictedPage = () => {
  return (
    <>
      <Head>
        <title>Permission Required</title>
        <meta name="viewport" content="width=device-width, initial-scale=1" />
      </Head>
      <PageLoading />
      <main>
        <DashboardLayout title="Restricted Access" loading={false} activemenu="restricted">
          <Row gutter={[10, 10]}>
            <Col span={24}>
                <Result
                    status="403"
                    title="You do not have permission to access this page."
                    subTitle="This page is restricted to certain users only."
                    extra={<Button type="primary" onClick={() => router.replace('/dashboard')}>Back Home</Button>}
                />
            </Col>
            </Row>
        </DashboardLayout>
      </main>
    </>
  )
}

export default withAuth(RestrictedPage);