import { useSession } from 'next-auth/react';
import { useRouter } from 'next/router';
import { useContext, useEffect } from 'react';
import Loading from '../Loading';
import RestrictedPage from './RestrictedPage';
import AppContext from '@/context/AppContext';

const checkPagePermissions = (permissionsRequired) => (Component) => {
  const WrappedComponent = (props) => {
    const { data: session, status } = useSession();
    const router = useRouter();
    const context = useContext(AppContext);
    const orgId = context?.activeOrg?._id || null;

    useEffect(() => {
      if (status === "unauthenticated") {
        router.push("/login");
      }
    }, [status]);

    if (status === "loading") {
      return <Loading isLoading={true} />;
    }

    if (status === "authenticated") {
      const userPermissions = session?.org_access?.[orgId] || [];

      const hasRequiredPermissions = permissionsRequired.some(permission =>
        userPermissions.includes(permission)
      );

      if (!hasRequiredPermissions) {
        return <RestrictedPage />;
      }

      return <Component {...props} />;
    }

    return null; // Fallback, should not reach here
  };

  WrappedComponent.displayName = `checkPagePermissions(${Component.displayName || Component.name || 'Component'})`;

  return WrappedComponent;
};

export default checkPagePermissions;