import { useRouter } from 'next/router';
import { useEffect } from 'react';

import { useSession } from 'next-auth/react';
import Loading from '@/components/Loading';
import CheckActiveOrg from './CheckActiveOrg';
import RestrictedPage from './RestrictedPage';

const withAdminAuth = (Component) => {
  const WrappedComponent = (props) => {
    const router = useRouter();
    const { status, data: session } = useSession();

    useEffect(() => {
      if (status === "unauthenticated") {
        router.push("/login");
      }
    }, [status]);

    if (status === "authenticated") {
        const isSuperAdmin = session?.user?.isSuperAdmin;

        if (!isSuperAdmin) {
            return <RestrictedPage />;
        }
      return (<CheckActiveOrg>
        <Component {...props} />;
      </CheckActiveOrg>)
    }

    return (
        <Loading isLoading={true}/>
    );
  };

  WrappedComponent.displayName = `withAdminAuth(${Component.displayName || Component.name || 'Component'})`;

  return WrappedComponent;
};

export default withAdminAuth;