import { useRouter } from 'next/router';
import { useContext, useEffect } from 'react';

import { useSession } from 'next-auth/react';
import Loading from '@/components/Loading';
import AppContext from '@/context/AppContext';
import CheckActiveOrg from './CheckActiveOrg';

const withAuth = (Component) => {
  const WrappedComponent = (props) => {
    const router = useRouter();
    const context = useContext(AppContext)
    const { status } = useSession();

    useEffect(() => {
      if (status === "unauthenticated") {
        router.push("/login");
      }
    }, [status]);

    if (status === "authenticated") {
      return (<CheckActiveOrg>
        <Component {...props} />;
      </CheckActiveOrg>)
    }

    return (
        <Loading isLoading={true}/>
    );
  };

  WrappedComponent.displayName = `withAuth(${Component.displayName || Component.name || 'Component'})`;

  return WrappedComponent;
};

export default withAuth;