import Image from 'next/image'
import React, { useContext, useEffect, useRef, useState } from 'react'
import { RiHome4Line } from "react-icons/ri";
import { RiLightbulbFlashLine } from "react-icons/ri";
import { LuMessageSquareCode } from "react-icons/lu";
import { CgSmartphoneChip } from "react-icons/cg";
import { FaWhatsapp } from "react-icons/fa";
import { PiChatCircleTextBold, PiCrownSimpleDuotone } from "react-icons/pi";
import { LuContact } from "react-icons/lu";
import { RiLayoutVerticalLine } from "react-icons/ri";
import { LuFolderOpen } from "react-icons/lu";
import { TbBuildingSkyscraper, TbLogout, TbSettings2, TbUserSquareRounded } from "react-icons/tb";
import { LuWalletCards } from "react-icons/lu";
import { RiMenuFold3Line } from "react-icons/ri";
import { RiMenuFold4Line } from "react-icons/ri";
import { RiArrowDownWideFill } from "react-icons/ri";
import { useRouter } from 'next/router';
import { getRandomAvatar } from '@/utils/randomavatar';
import AppContext from '@/context/AppContext';
import { limitStringLength } from '@/utils/limitstringlength';
import ToggleTheme from '../utils/ToggleTheme';
import { signOut } from 'next-auth/react';
import { BiDollar } from "react-icons/bi";

const DashboardLayout = ({
    children, title = 'Dashboard', loading = false, activemenu = 'dashboard'
}) => {
    const [sidebarOpen, setSidebarOpen] = useState(false);
    const [dropMenuOpen, setDropMenuOpen] = useState(false);
    const router = useRouter();
    const context = useContext(AppContext)

    // Create a ref for the dropdown menu content
    const dropMenuRef = useRef(null);
    const avatarRef = useRef(null);

    // Close dropdown when clicking outside
    useEffect(() => {
        const handleClickOutside = (event) => {
            // If click is outside both the menu content and the avatar button
            if (dropMenuOpen && 
                dropMenuRef.current && 
                !dropMenuRef.current.contains(event.target) &&
                avatarRef.current &&
                !avatarRef.current.contains(event.target)) {
                setDropMenuOpen(false);
            }
        };

        // Add event listener when dropdown is open
        if (dropMenuOpen) {
            document.addEventListener('mousedown', handleClickOutside);
        }

        // Clean up
        return () => {
            document.removeEventListener('mousedown', handleClickOutside);
        };
    }, [dropMenuOpen]);
  return (
    <section className={`dashboard_layout ${sidebarOpen ? 'sidebar_open' : ''}`}>
        <div className='dl_sidebar'>
            <div className='dl_sidebar_toggle' onClick={() => setSidebarOpen(!sidebarOpen)}>
                {
                    !sidebarOpen ? <RiMenuFold4Line /> : <RiMenuFold3Line />
                }
            </div>
            <div className='dl_sidebar_logo'>
                <Image className='dark' width={300} height={100} src={'/images/sendiee_logo.png'} alt='Seniee Logo' />
                <Image className='light' width={300} height={100} src={'/images/sendiee_logo_dark.png'} alt='Seniee Logo' />
            </div>
            <div className='dl_org_selector' onClick={() => router.push('/dashboard/selectorg')}>
                <div className='dl_org_selector_icon'>
                    <Image width={30} height={30} src={getRandomAvatar()} alt='Organization Icon' />
                </div>
                <div className='dl_org_selector_name'>
                    {limitStringLength(context?.activeOrg?.name, 15) || 'Select Organization'}
                    {context?.activeOrg?.isOwner && <span>
                        <PiCrownSimpleDuotone />
                    </span>}
                </div>
                <div className='selector_arrow'>
                    <RiArrowDownWideFill />
                </div>
            </div>
            <div className='dl_sidebar_menu'>
                <div className='dl_sidebar_menu_group'>
                    <div className='menu_group_label'>
                        Menu
                    </div>
                    <div className={`menu_group_item ${(activemenu === 'dashboard') && 'active'}`} onClick={() => router.push('/dashboard')}>
                        <div className='icon'>
                            <RiHome4Line />
                        </div>
                        <div className='label'>
                            Dashboard
                        </div>
                    </div>
                    <div className={`menu_group_item ${(activemenu === 'insights') && 'active'}`} onClick={() => router.push('/dashboard/insights')}>
                        <div className='icon'>
                            <RiLightbulbFlashLine />
                        </div>
                        <div className='label'>
                            Insights
                        </div>
                    </div>
                </div>
                <div className='dl_sidebar_menu_group'>
                    <div className='menu_group_label'>
                        Build
                    </div>
                    <div className={`menu_group_item ${(activemenu === 'models') && 'active'}`} onClick={() => router.push('/dashboard/models')}>
                        <div className='icon'>
                            <LuMessageSquareCode />
                        </div>
                        <div className='label'>
                            AI Models
                        </div>
                    </div>
                    <div className={`menu_group_item ${(activemenu === 'tools') && 'active'}`} onClick={() => router.push('/dashboard/tools')}>
                        <div className='icon'>
                            <CgSmartphoneChip />
                        </div>
                        <div className='label'>
                            Tools
                        </div>
                    </div>
                    <div className={`menu_group_item ${(activemenu === 'waaccounts') && 'active'}`} onClick={() => router.push('/dashboard/waaccounts')}>
                        <div className='icon'>
                            <FaWhatsapp />
                        </div>
                        <div className='label'>
                            WhatsApp Accounts
                        </div>
                    </div>
                </div>
                {/* <div className='dl_sidebar_menu_group'>
                    <div className='menu_group_label'>
                        Message
                    </div>
                    <div className={`menu_group_item ${(activemenu === 'campaign') && 'active'}`} onClick={() => router.push('/dashboard/campaign')}>
                        <div className='icon'>
                            <PiChatCircleTextBold />
                        </div>
                        <div className='label'>
                            Campaign
                        </div>
                    </div>
                    <div className={`menu_group_item ${(activemenu === 'contacts') && 'active'}`} onClick={() => router.push('/dashboard/contacts')}>
                        <div className='icon'>
                            <LuContact />
                        </div>
                        <div className='label'>
                            Contacts
                        </div>
                    </div>
                    <div className={`menu_group_item ${(activemenu === 'templates') && 'active'}`} onClick={() => router.push('/dashboard/templates')}>
                        <div className='icon'>
                            <RiLayoutVerticalLine />
                        </div>
                        <div className='label'>
                            Templates
                        </div>
                    </div>
                    <div className={`menu_group_item ${(activemenu === 'filemanager') && 'active'}`} onClick={() => router.push('/dashboard/filemanager')}>
                        <div className='icon'>
                            <LuFolderOpen />
                        </div>
                        <div className='label'>
                            File Manager
                        </div>
                    </div>
                </div> */}
                <div className='dl_sidebar_menu_group'>
                    <div className='menu_group_label'>
                        Organization
                    </div>
                    <div className={`menu_group_item ${(activemenu === 'settings') && 'active'}`} onClick={() => router.push('/dashboard/settings')}>
                        <div className='icon'>
                            <TbSettings2 />
                        </div>
                        <div className='label'>
                            Manage Org
                        </div>
                    </div>
                    <div className={`menu_group_item ${(activemenu === 'wallet') && 'active'}`} onClick={() => router.push('/dashboard/wallet')}>
                        <div className='icon'>
                            <LuWalletCards />
                        </div>
                        <div className='label'>
                            Wallet
                        </div>
                    </div>
                </div>
                {
                    context?.userInfo?.isSuperAdmin && (
                    <div className='dl_sidebar_menu_group'>
                        <div className='menu_group_label'>
                            Admin Area
                        </div>
                        <div className={`menu_group_item ${(activemenu === 'servers') && 'active'}`} onClick={() => router.push('/admin/servers')}>
                            <div className='icon'>
                                <TbSettings2 />
                            </div>
                            <div className='label'>
                                Servers
                            </div>
                        </div>
                        <div className={`menu_group_item ${(activemenu === 'orgs') && 'active'}`} onClick={() => router.push('/admin/orgs')}>
                            <div className='icon'>
                                <TbBuildingSkyscraper />
                            </div>
                            <div className='label'>
                                Organizations
                            </div>
                        </div>
                        <div className={`menu_group_item ${(activemenu === 'adminusers') && 'active'}`} onClick={() => router.push('/admin/users')}>
                            <div className='icon'>
                                <TbUserSquareRounded />
                            </div>
                            <div className='label'>
                                Users
                            </div>
                        </div>
                        <div className={`menu_group_item ${(activemenu === 'adminpricing') && 'active'}`} onClick={() => router.push('/admin/pricing')}>
                            <div className='icon'>
                                <BiDollar />
                            </div>
                            <div className='label'>
                                Pricing
                            </div>
                        </div>
                    </div>
                    )
                }
            </div>
        </div>
        <div className='dl_content_wrapper'>
            <div className='dl_topbar'>
                <div className='dl_topbar_title'>
                    <h1 className='dl_title'>{title}</h1>
                </div>
                <div className='dl_topbar_actions'>
                    <div className='dl_org_selector' onClick={() => router.push('/dashboard/selectorg')}>
                        <div className='dl_org_selector_icon'>
                            <Image width={30} height={30} src={getRandomAvatar(context?.activeOrg?.uniqueId)} alt='Organization Icon' />
                        </div>
                        <div className='dl_org_selector_name'>
                            {limitStringLength(context?.activeOrg?.name, 15) || 'Select Organization'}
                            {context?.activeOrg?.isOwner && <span>
                                <PiCrownSimpleDuotone />
                            </span>}
                        </div>
                        <div className='selector_arrow'>
                            <RiArrowDownWideFill />
                        </div>
                    </div>

                    <div className={`dl_topbar_dropmenu ${dropMenuOpen ? 'open' : ''}`}>
                        <div className='dropmenu_avatar' onClick={() => setDropMenuOpen(!dropMenuOpen)} ref={avatarRef} >
                            S
                        </div>
                        {dropMenuOpen && ( <div className='dropmenu_menucontent' ref={dropMenuRef}>
                            <ToggleTheme />
                            {/* <div className='dl_dropdown_item' onClick={() => router.push('/dashboard/profile')}>
                                <div className='icon'>
                                    <TbUserSquareRounded />
                                </div>
                                <div className='label'>
                                    Profile
                                </div>
                            </div> */}
                            <div className='dl_dropdown_item' onClick={() => router.push('/dashboard/profile')}>
                                <div className='icon'>
                                    <LuWalletCards />
                                </div>
                                <div className='label'>
                                    Wallet
                                </div>
                            </div>
                            <div className='dl_dropdown_item' onClick={() => router.push('/dashboard/settings')}>
                                <div className='icon'>
                                    <TbSettings2 />
                                </div>
                                <div className='label'>
                                    Org Settings
                                </div>
                            </div>
                            <div className='dl_dropdown_item' onClick={() => signOut()}>
                                <div className='icon'>
                                    <TbLogout />
                                </div>
                                <div className='label'>
                                    Logout
                                </div>
                            </div>
                        </div>)}
                    </div>
                </div>
            </div>
            <div className='dl_content'>
                {children}
            </div>
        </div>
    </section>
  )
}

export default DashboardLayout