import React, { useEffect } from 'react'

const OnboardCustomer = () => {
    // const handleConnect = () => {
    //     const appId = process.env.NEXT_PUBLIC_META_APP_ID;
    //     const graphApiVersion = process.env.NEXT_PUBLIC_GRAPH_API_VERSION;
    //     const redirectUri = encodeURIComponent(process.env.NEXT_PUBLIC_META_REDIRECT_URI);
    //     const scopes = [
    //     'whatsapp_business_messaging',
    //     'whatsapp_business_management',
    //     'business_management',
    //     'pages_show_list'
    //     ];

    //     const authUrl = `https://www.facebook.com/${graphApiVersion}/dialog/oauth?client_id=${appId}&redirect_uri=${redirectUri}&scope=${scopes.join(',')}&response_type=code`;
    //     window.location.href = authUrl;
    // };

    // Load Facebook SDK
  useEffect(() => {
    const loadFbSdk = () => {
        console.log('📨 Loading Facebook SDK...', window?.FB);
      if (window.FB) return;

      window.fbAsyncInit = function () {
        window.FB.init({
          appId: process.env.NEXT_PUBLIC_META_APP_ID,
          autoLogAppEvents: true,
          xfbml: true,
          version: process.env.NEXT_PUBLIC_GRAPH_API_VERSION,
        });
      };

      const script = document.createElement('script');
      script.src = 'https://connect.facebook.net/en_US/sdk.js';
      script.async = true;
      script.defer = true;
      script.crossOrigin = 'anonymous';
      document.body.appendChild(script);

      console.log('📨 Loading Facebook SDK...', );
    };

    loadFbSdk();

    // Message listener
    const handler = (event) => {
      if (!event.origin.endsWith('facebook.com')) return;

      try {
        const data = JSON.parse(event.data);
        if (data.type === 'WA_EMBEDDED_SIGNUP') {
          console.log('📨 Received WA_EMBEDDED_SIGNUP message:', data);
          // Optionally: handle onboarding complete state
        }
      } catch (err) {
        console.log('📨 Received non-JSON message:', event.data);
      }
    };

    window.addEventListener('message', handler);
    return () => window.removeEventListener('message', handler);
  }, []);

  const launchSignup = () => {
    if (!window.FB) {
      console.error('Facebook SDK not initialized yet');
      return;
    }

    window.FB.login(
      (response) => {
        if (response.authResponse) {
          console.log('✅ Success response:', response);
          // Redirect to backend callback if needed
          // For example: window.location.href = `/api/auth/facebook/callback?code=${response.authResponse.code}`
        } else {
          console.log('❌ Login cancelled or failed:', response);
        }
      },
      {
        config_id: process.env.NEXT_PUBLIC_META_EMBEDDED_CONFIG_ID, // Meta Embedded Signup config ID
        response_type: 'code',
        override_default_response_type: true,
        extras: {
          setup: {}, // You can pre-fill business data here
          featureType: 'whatsapp_business_app_onboarding', 
          sessionInfoVersion: '3',
        },
      }
    );
  };

    return (
        <div>
        <button onClick={launchSignup} 
        style={{
            backgroundColor: '#1877f2',
            border: 0,
            borderRadius: '4px',
            color: '#fff',
            cursor: 'pointer',
            fontFamily: 'Helvetica, Arial, sans-serif',
            fontSize: '16px',
            fontWeight: 'bold',
            height: '40px',
            padding: '0 24px',
        }}
        >Login with Facebook</button>
        </div>
    );
}

export default OnboardCustomer