import React, { useEffect, useState } from 'react'
import { useRouter } from 'next/router';
import Loading from '../Loading';

const PageLoading = () => {
    const [isLoading, setIsLoading] = useState(false);
    const router = useRouter();
    useEffect(() => {
        const handleStart = () => {
          setIsLoading(true);
        };
      
        const handleComplete = () => {
          setIsLoading(false);
        };
      
        router.events.on('routeChangeStart', handleStart);
        router.events.on('routeChangeComplete', handleComplete);
        router.events.on('routeChangeError', handleComplete);
      
        return () => {
          router.events.off('routeChangeStart', handleStart);
          router.events.off('routeChangeComplete', handleComplete);
          router.events.off('routeChangeError', handleComplete);
        };
    }, []);
  return (
    <>
         <Loading isLoading={isLoading}/>
    </>
  )
}

export default PageLoading