import AppContext from '@/context/AppContext';
import { Switch } from 'antd';
import React, { useContext, useEffect, useState } from 'react'
import { FiMoon, FiSun } from 'react-icons/fi';

const ToggleTheme = () => {
    const [theme, setTheme] = useState(localStorage.getItem('theme') || 'light');

    const context = useContext(AppContext);

    useEffect(() => {
        document.documentElement.setAttribute('data-theme', theme);
        context.setDrakTheme((theme === 'dark') ? true : false)
    }, [theme]);

    useEffect(() => {
        const theme = localStorage.getItem('theme') || 'light';
        setTheme(theme);
        context.setDrakTheme((theme === 'dark') ? true : false)
    }, []);

    const handleToggleTheme = () => {
        setTheme(theme === 'light' ? 'dark' : 'light');
        localStorage.setItem('theme', (theme === 'light' ? 'dark' : 'light'))
    }

    const handleSetTheme = (value = 'light') => {
        setTheme(value);
        localStorage.setItem('theme', value);
    }
    return (
        <div className={`theme_toggle_group ${context.isDarkTheme ? 'dark' : 'light'}`}>
            <div className='theme_dark theme_button' onClick={() => handleSetTheme('dark')}>
                <FiMoon />
            </div>
            <div className='theme_light theme_button' onClick={() => handleSetTheme('light')}>
                <FiSun />
            </div>
        </div>
    )
}

export default ToggleTheme