import mongoose from 'mongoose';

const AIModelSchema = new mongoose.Schema({
    orgId: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'Organization',
        required: [true, 'Organization ID is required'],
    },
    instance_id: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'QR',
    },
    phone: {
        type: String,
        trim: true,
    },
    name: {
        type: String,
        required: [true, 'Model name is required'],
        trim: true,
    },
    description: {
        type: String,
        trim: true,
    },
    modelId: {
        type: String,
        required: [true, 'Model ID is required'],
        unique: true,
        trim: true,
    },
    provider: {
        type: String,
        required: [true, 'Provider is required'],
        enum: ['openai', 'google'],
        default: 'openai',
    },
    model: {
        type: String,
        required: [true, 'Model is required'],
        trim: true,
        default: 'gpt-4.1',
    },
    maxTokens: {
        type: Number,
        default: 250,
        min: 1,
    },
    temperature: {
        type: Number,
        default: 0.7,
        min: 0,
        max: 1,
    },
    topP: {
        type: Number,
        default: 1,
        min: 0,
        max: 1,
    },
    systemPrompt: {
        type: String,
        trim: true,
        default: '',
    },
    tools: [
        {
            type: mongoose.Schema.Types.ObjectId,
            ref: 'AITool',
            required: false,
        }
    ],
    voiceEnabled: {
        type: Boolean,
        default: false,
    },
    imageEnabled: {
        type: Boolean,
        default: false,
    },
    isActive: {
        type: Boolean,
        default: true,
    },
    phoneNumbersList: [
        {
            type: String,
            trim: true,
        }
    ],
    spamList: [
        {
            type: String,
            trim: true,
        }
    ],
    isNumbersExcluded: {
        type: Boolean,
        default: true,
    },
    disableCommand: {
        type: String,
        trim: true,
    },
    enableCommand: {
        type: String,
        trim: true,
    },
    disableDuration: {
        type: Number,
        default: 30, // Duration in minutes
        min: 0,
    },
    createdAt: {
        type: Date,
        default: Date.now,
    },
    updatedAt: {
        type: Date,
        default: Date.now,
    },
}, {
    timestamps: true,
    versionKey: false,
});

AIModelSchema.pre('save', function(next) {
    this.updatedAt = Date.now();
    next();
});

const AIModel = mongoose.models.AIModel || mongoose.model('AIModel', AIModelSchema);
export default AIModel;