import mongoose from 'mongoose';

const AIPricingSchema = new mongoose.Schema({
    model: {
        type: String,
        required: [true, 'Model is required'],
        trim: true,
        unique: true,
    },
    pricing: {
        type: Object,
        required: [true, 'Pricing details are required'],
        default: {
            input: 0,
            output: 0,
            cache: 0,
        },
    },
    currency: {
        type: String,
        default: 'USD',
    },
    createdAt: {
        type: Date,
        default: Date.now,
    },
    updatedAt: {
        type: Date,
        default: Date.now,
    },
}, {
    timestamps: true,
    versionKey: false,
});

AIPricingSchema.pre('save', function (next) {
    this.updatedAt = Date.now();
    next();
});

const AIPricing = mongoose.models.AIPricing || mongoose.model('AIPricing', AIPricingSchema);
export default AIPricing;