import mongoose from 'mongoose';

const AIToolSchema = new mongoose.Schema({
    orgId: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'Organization',
        required: [true, 'Organization ID is required'],
    },
    name: {
        type: String,
        trim: true,
    },
    description: {
        type: String,
        trim: true,
    },
    toolId: {
        type: String,
        required: [true, 'Tool ID is required'],
        unique: true,
        trim: true,
    },
    toolType: {
        type: String,
        enum: ['custom_function', 'api_request', 'google_calendar', 'function'],
        required: [true, 'Tool type is required'],
        default: 'function',
    },
    isStatic: {
        type: Boolean,
        default: false,
    },
    response: {
        type: String,
    },
    isActive: {
        type: Boolean,
        default: true,
    },
    serverUrl: {
        type: String,
        required: false,
        trim: true,
    },
    secretToken: {
        type: String,
        trim: true,
    },
    parameters: {
        type: Object,
        default: {},
    },
    strict: {
        type: Boolean,
        default: false,
    },
    async: {
        type: Boolean,
        default: false,
    },
    createdAt: {
        type: Date,
        default: Date.now,
    },
    updatedAt: {
        type: Date,
        default: Date.now,
    },
}, {
    timestamps: true,
    versionKey: false,
});

AIToolSchema.pre('save', function(next) {
    this.updatedAt = Date.now();
    next();
});

const AITool = mongoose.models.AITool || mongoose.model('AITool', AIToolSchema);
export default AITool;