import mongoose from 'mongoose';

const businessCustomerSchema = new mongoose.Schema({
    businessName: {
        type: String,
        trim: true,
    },
    orgId: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'Organization',
    },
    userId: {
        type: String,
    },
    accessToken: {
        type: String,
    },
    phoneNumberId: {
        type: String,
    },
    wabaId: {
        type: String,
    },
    businessId: {
        type: String,
    },
    businessPhoneNumber: {
        type: String,
    },
    tokenLastUpdated: {
        type: Date,
        default: Date.now,
    },
    createdAt: {
        type: Date,
        default: Date.now,
    },
    updatedAt: {
        type: Date,
        default: Date.now,
    },
}, {
    timestamps: true,
    versionKey: false,
});

const BusinessCustomer = mongoose.models.BusinessCustomer || mongoose.model('BusinessCustomer', businessCustomerSchema);
export default BusinessCustomer;
