import mongoose from 'mongoose';

const QRSchema = new mongoose.Schema({
    instance_id: {
        type: String,
        required: [true, 'Instance ID is required'],
        trim: true,
    },
    orgId: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'Organization',
        required: [true, 'Organization ID is required'],
    },
    name: {
        type: String,
        trim: true,
    },
    phone: {
        type: String,
        trim: true,
    },
    QRCode: {
        type: String,
        default: '',
    },
    count: { 
        type: Number, default: 0
    },
    status: {
        type: String,
        enum: ['loading', 'active', 'scanned', 'expired'],
        default: 'loading',
    },
    serverUrl: {
        type: String,
        required: [true, 'Server URL is required'],
        trim: true,
    },
    createdAt: {
        type: Date,
        default: Date.now,
    },
    updatedAt: {
        type: Date,
        default: Date.now,
    },
}, {
    timestamps: true,
    versionKey: false,
})

QRSchema.pre('save', function(next) {
    this.updatedAt = Date.now();
    next();
});

const QR = mongoose.models.QR || mongoose.model('QR', QRSchema);
export default QR;