import mongoose from 'mongoose';

const ServerSchema = new mongoose.Schema({
    serverUrl: {
        type: String,
        required: [true, 'Server URL is required'],
        trim: true,
    },
    orgId: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'Organization',
        default: null,
    },
    type: {
        type: String,
        enum: ['default', 'special',],
        default: 'default',
    },
    notes: {
        type: String,
        trim: true,
        default: '',
    },
    isActive: {
        type: Boolean,
        default: true,
    },
    maxLimits: {
        type: Number,
        default: 1,
    },
    createdAt: {
        type: Date,
        default: Date.now,
    },
    updatedAt: {
        type: Date,
        default: Date.now,
    },
}, {
    timestamps: true,
    versionKey: false,
});

ServerSchema.pre('save', function(next) {
    this.updatedAt = Date.now();
    next();
});

const Server = mongoose.models.Server || mongoose.model('Server', ServerSchema);
export default Server;