import mongoose from 'mongoose';

const TransactionSchema = new mongoose.Schema({
    orgId: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'Organization',
        required: [true, 'Organization ID is required'],
    },
    instanceId: {
        type: String,
        trim: true,
    },
    phoneNumber: {
        type: String,
        trim: true,
    },
    imageCount: {
        type: Number,
        default: 0,
    },
    audioCount: {
        type: Number,
        default: 0,
    },
    textCount: {
        type: Number,
        default: 0,
    },
    timestamp: {
        type: Date,
        default: Date.now,
    },
    responseImageCount: {
        type: Number,
        default: 0,
    },
    responseAudioCount: {
        type: Number,
        default: 0,
    },
    totalTokensUsed: {
        type: Number,
        default: 0,
    },
    inputTokens: {
        type: Number,
        default: 0,
    },
    outputTokens: {
        type: Number,
        default: 0,
    },
    cachedTokens: {
        type: Number,
        default: 0,
    },
    audioTokens: {
        type: Number,
        default: 0,
    },
    amountConsumed: {
        type: Number,
        default: 0,
    },
    toolsUsed: {
        type: Number,
        default: 0,
    },
    modelName: {
        type: String,
        default: '',
    },
    type: {
        type: String,
        default: '',
        enum: ['DEBIT', 'CREDIT', 'REFUND', 'CHARGE'],
    },
    category: {
        type: String,
        default: '',
        enum: ['AI', 'ADD_FUNDS', 'SUBSCRIPTION'],
    },
    isDummy: {
        type: Boolean,
        default: false,
    },
}, {
    timestamps: true,
    versionKey: false,
});

const Transaction = mongoose.models.Transaction || mongoose.model('Transaction', TransactionSchema);
export default Transaction;