import { authOptions } from "@/pages/api/auth/[...nextauth]";
import { getServerSession } from "next-auth";

export const checkOrgPermissions = (permissionsRequired, orgId) => {
    return async (req, res, next) => {
      const session = await getServerSession(req, res, authOptions)
  
      const userPermissions = session?.org_access?.[orgId] || [];

      const hasRequiredPermissions = permissionsRequired.some(permission => 
        userPermissions.includes(permission)
      );
  
      if (!hasRequiredPermissions) {
        return res.status(401).json({ status: 'fail', message: 'Unauthorized access' });
      }
  
      return next(req, res);
    };
  };