import dbConnect from '@/lib/db/dbConnect';

export default async function databaseMiddleware(req, res, next) {
  try {
    await dbConnect();
    next();
  } catch (error) {
    console.error('Database connection error:', error);
    res.status(500).json({ error: 'Database connection failed' });
  }
}