import PageLoading from '@/components/utils/PageLoading'
import { Button, Result } from 'antd'
import Head from 'next/head'
import Link from 'next/link'
import React from 'react'

const PageNotFound = () => {
  return (
    <>
    <Head>
        <title>Page Not Found | Sendiee</title>
        <meta name="viewport" content="width=device-width, initial-scale=1" />
      </Head>
      <PageLoading />
      <main>
        <Result
            status="404"
            title="404"
            subTitle="Sorry, the page you visited does not exist."
            extra={<Link href="/"><Button type="primary">Back Home</Button></Link>}
        ></Result>
      </main>
    </>
  )
}

export default PageNotFound