import CheckUserAccess from "@/components/auth/CheckUserAccess";
import AppContext from "@/context/AppContext";
import "@/styles/globals.css";
import "@/styles/layout.scss";
import { ConfigProvider, theme } from "antd";
import { SessionProvider } from "next-auth/react";
import { useEffect, useState } from "react";
import { PiSpinnerBold } from "react-icons/pi";

export default function App({ Component, pageProps }) {
  const [userInfo, setUserInfo] = useState({})
  const [orgList, setOrgList] = useState([])
  const [activeOrg, setActiveOrg] = useState({});
  const [themeMode, setTheme] = useState('light');
  const [isDarkTheme, setDrakTheme] = useState(false);
  
  useEffect(() => {
      if (typeof window === 'undefined') return;
      document.documentElement.setAttribute('data-theme', themeMode);
      setDrakTheme((themeMode === 'dark') ? true : false)
  }, [themeMode]);

  useEffect(() => {
    if (typeof window !== 'undefined') {
      const themeMode = localStorage?.getItem('theme') || 'light';
      setTheme(themeMode);
      setDrakTheme((themeMode === 'dark') ? true : false)
    }
  }, []);
  return <>
    <SessionProvider session={pageProps.session}>
      <AppContext.Provider value={{userInfo, setUserInfo, orgList, setOrgList, activeOrg, setActiveOrg, isDarkTheme, setDrakTheme}}>
        <CheckUserAccess>
          <ConfigProvider
                theme={{
                  algorithm: isDarkTheme ? theme.darkAlgorithm : theme.defaultAlgorithm,
                  token: {
                    colorPrimary: '#A85EFA',
                  },
                  components: {
                    Card: {
                      borderRadiusLG: 10, 
                    },
                    Divider: {
                      fontSize: 14,
                    }
                  },
                }}
                spin={{
                  indicator: <PiSpinnerBold className="spin" spin style={{ fontSize: '24px', color: '#A85EFA' }} />, // Custom loading icon
                }}
              >
              <Component {...pageProps} />
          </ConfigProvider>
        </CheckUserAccess>
      </AppContext.Provider>
    </SessionProvider>
  </>;
}
