import dbConnect from '@/lib/db/dbConnect';
import { getServerSession } from 'next-auth';
import { withAdminAuth } from '../../withAdminAuth';
import { authOptions } from '../../auth/[...nextauth]';
import Organization from '@/lib/models/Organization';
import User from '@/lib/models/User';
import Wallet from '@/lib/models/Wallet';

const endpoint = async (req, res) => {
    if (req.method !== 'GET') {
        return res.status(405).json({ 
        status: 'fail',
        message: 'Method not allowed' 
        });
    }
    await dbConnect();
    try{

        const { type } = req.query;

        const session = await getServerSession(req, res, authOptions)

        const userId = session?.user?.userId;

        if (!userId || userId === undefined || userId === null || userId === '') {
            return res.status(400).json({ 
                status: 'fail',
                message: 'Please login to proceed' 
            });
        }

        // Fetch all orgs
        let orgs = [];
        let wallets = [];
        if (type === 'active') {
            orgs = await Organization.find({ isActive: true })
            .sort({ createdAt: -1 });
        }
        else if (type === 'inactive') {
            orgs = await Organization.find({ isActive: false })
            .sort({ createdAt: -1 });
        }
        else {
            // include wallet balance in the orgs data
            orgs = await Organization.find({})
            .populate('ownerId', 'name email')
            .sort({ createdAt: -1 });

            wallets = await Wallet.find({}).select('orgId balance');
        }

        return res.status(200).json({
            status: 'success',
            message: 'Orgs list fetched successfully',
            data: orgs,
            wallets: wallets
        });
    }catch(err){
        console.log('Error fetching orgs', err);
        return res.status(500).json({
            status: 'fail',
            message: err.message || 'Failed to fetch orgs'
        })
    }
}

export default withAdminAuth(async(req, res) => {
  await endpoint(req, res);
});