import dbConnect from '@/lib/db/dbConnect';
import { getServerSession } from 'next-auth';
import { withAdminAuth } from '../../withAdminAuth';
import { authOptions } from '../../auth/[...nextauth]';
import AIPricing from '@/lib/models/AIPricing';

const endpoint = async (req, res) => {
    if (req.method !== 'POST') {
        return res.status(405).json({ 
            status: 'fail',
            message: 'Method not allowed' 
        });
    }
    await dbConnect();
    try{

        const { model, input, output, cache } = req.body;

        if (!model || model === undefined || model === null || model === '') {
            return res.status(400).json({ 
                status: 'fail',
                message: 'Model is required' 
            });
        }

        const session = await getServerSession(req, res, authOptions)

        const userId = session?.user?.userId;

        if (!userId || userId === undefined || userId === null || userId === '') {
            return res.status(400).json({ 
                status: 'fail',
                message: 'Please login to proceed' 
            });
        }

        // Create the pricing data
        const pricingData = new AIPricing({
            model,
            pricing: {
                output: output || 0,
                cache: cache || 0,
                input: input || 0,
            },
        });
        await pricingData.save();

        return res.status(200).json({
            status: 'success',
            message: 'Pricing data created successfully',
        });
    }catch(err){
        console.log('Error creating pricing', err);
        return res.status(500).json({
            status: 'fail',
            message: err.message || 'Failed to create pricing'
        })
    }
}

export default withAdminAuth(async(req, res) => {
  await endpoint(req, res);
});