import dbConnect from '@/lib/db/dbConnect';
import { getServerSession } from 'next-auth';
import { withAdminAuth } from '../../withAdminAuth';
import { authOptions } from '../../auth/[...nextauth]';
import AIPricing from '@/lib/models/AIPricing';

const endpoint = async (req, res) => {
    if (req.method !== 'POST') {
        return res.status(405).json({ 
            status: 'fail',
            message: 'Method not allowed' 
        });
    }
    await dbConnect();
    try{

        const { _id } = req.body;

        if (!_id || _id === undefined || _id === null || _id === '') {
            return res.status(400).json({ 
                status: 'fail',
                message: 'Required parameters are missing'
            });
        }

        const session = await getServerSession(req, res, authOptions)

        const userId = session?.user?.userId;

        if (!userId || userId === undefined || userId === null || userId === '') {
            return res.status(400).json({ 
                status: 'fail',
                message: 'Please login to proceed' 
            });
        }

        // Delete the pricing
        const pricing = await AIPricing.findByIdAndDelete(_id);
        if (!pricing) {
            return res.status(404).json({ 
                status: 'fail',
                message: 'Pricing not found' 
            });
        }
        return res.status(200).json({
            status: 'success',
            message: 'Pricing deleted successfully',
        });

    }catch(err){
        console.log('Error deleting pricing', err);
        return res.status(500).json({
            status: 'fail',
            message: err.message || 'Failed to delete pricing'
        })
    }
}

export default withAdminAuth(async(req, res) => {
  await endpoint(req, res);
});