import dbConnect from '@/lib/db/dbConnect';
import { getServerSession } from 'next-auth';
import { withAdminAuth } from '../../withAdminAuth';
import { authOptions } from '../../auth/[...nextauth]';
import AIPricing from '@/lib/models/AIPricing';

const endpoint = async (req, res) => {
    if (req.method !== 'POST') {
        return res.status(405).json({ 
            status: 'fail',
            message: 'Method not allowed' 
        });
    }
    await dbConnect();
    try{

        const session = await getServerSession(req, res, authOptions)

        const userId = session?.user?.userId;

        if (!userId || userId === undefined || userId === null || userId === '') {
            return res.status(400).json({ 
                status: 'fail',
                message: 'Please login to proceed' 
            });
        }

        const list = await AIPricing.find({})

        return res.status(200).json({
            status: 'success',
            message: 'Pricing list fetched successfully',
            data: list,
        });
    }catch(err){
        console.log('Error fetching pricing', err);
        return res.status(500).json({
            status: 'fail',
            message: err.message || 'Failed to fetch pricing'
        })
    }
}

export default withAdminAuth(async(req, res) => {
  await endpoint(req, res);
});