import dbConnect from '@/lib/db/dbConnect';
import { getServerSession } from 'next-auth';
import { withAdminAuth } from '../../withAdminAuth';
import { authOptions } from '../../auth/[...nextauth]';
import AIPricing from '@/lib/models/AIPricing';

const endpoint = async (req, res) => {
    if (req.method !== 'POST') {
        return res.status(405).json({ 
            status: 'fail',
            message: 'Method not allowed' 
        });
    }
    await dbConnect();
    try{

        const { _id, model, input, output, cache } = req.body;

        if (!model || model === undefined || model === null || model === '' || !_id) {
            return res.status(400).json({ 
                status: 'fail',
                message: 'Required parameters are missing' 
            });
        }

        const session = await getServerSession(req, res, authOptions)

        const userId = session?.user?.userId;

        if (!userId || userId === undefined || userId === null || userId === '') {
            return res.status(400).json({ 
                status: 'fail',
                message: 'Please login to proceed' 
            });
        }

        // Update the pricing data
        const pricingData = await AIPricing.findByIdAndUpdate(_id, {
            model,
            pricing: {
                output: output || 0,
                cache: cache || 0,
                input: input || 0,
            },
        }, { new: true });

        return res.status(200).json({
            status: 'success',
            message: 'Pricing data updated successfully',
        });
    }catch(err){
        console.log('Error updating pricing', err);
        return res.status(500).json({
            status: 'fail',
            message: err.message || 'Failed to update pricing'
        })
    }
}

export default withAdminAuth(async(req, res) => {
  await endpoint(req, res);
});