import { withAdminAuth } from '../../withAdminAuth';
import axios from 'axios';

const endpoint = async (req, res) => {
    if (req.method !== 'POST') {
        return res.status(405).json({ 
        status: 'fail',
        message: 'Method not allowed' 
        });
    }
    try{

        const { serverUrl } = req.body;

        if (!serverUrl) {
            return res.status(400).json({
                status: 'fail',
                message: 'Server URL is required'
            });
        }

        // Fetch server status
        const response = await axios.get(`${serverUrl}/getstatus`).catch(err => {
            console.error('Error fetching server status:', err);
            return res.status(500).json({
                status: 'fail',
                message: 'Server is not responding'
            });
        });

        const serverStatus = response.data;

        if (serverStatus?.status !== 'success') {
            return res.status(500).json({
                status: 'fail',
                message: 'Server is not responding'
            });
        }

        return res.status(200).json({
            status: 'success',
            message: 'Server is active',
        });
    }catch(err){
        console.log('Error checking server status', err);
        return res.status(500).json({
            status: 'fail',
            message: err.message || 'Failed to check server status'
        })
    }
}

export default withAdminAuth(async(req, res) => {
  await endpoint(req, res);
});