import dbConnect from '@/lib/db/dbConnect';
import { getServerSession } from 'next-auth';
import { withAdminAuth } from '../../withAdminAuth';
import { authOptions } from '../../auth/[...nextauth]';
import Server from '@/lib/models/Servers';
import QR from '@/lib/models/QR';

const endpoint = async (req, res) => {
    if (req.method !== 'POST') {
        return res.status(405).json({ 
        status: 'fail',
        message: 'Method not allowed' 
        });
    }
    await dbConnect();
    try{

        const { notes, serverUrl, orgId, maxLimits, isActive } = req.body;

        if (!serverUrl || !maxLimits) {
            return res.status(400).json({
                status: 'fail',
                message: 'Required parameter is missing'
            });
        }

        const session = await getServerSession(req, res, authOptions)

        const userId = session?.user?.userId;

        if (!userId || userId === undefined || userId === null || userId === '') {
            return res.status(400).json({ 
                status: 'fail',
                message: 'Please login to proceed' 
            });
        }

        // Add the server
        const newServer = new Server({
            notes,
            serverUrl,
            orgId,
            maxLimits: maxLimits || 1, 
            isActive: isActive || false,
            type: orgId ? 'special' : 'default',
        });

        await newServer.save();

        return res.status(200).json({
            status: 'success',
            message: 'Server added successfully',
        });
    }catch(err){
        console.log('Error adding server', err);
        return res.status(500).json({
            status: 'fail',
            message: err.message || 'Failed to add server'
        })
    }
}

export default withAdminAuth(async(req, res) => {
  await endpoint(req, res);
});