import dbConnect from '@/lib/db/dbConnect';
import { getServerSession } from 'next-auth';
import { withAdminAuth } from '../../withAdminAuth';
import { authOptions } from '../../auth/[...nextauth]';
import Server from '@/lib/models/Servers';
import QR from '@/lib/models/QR';

const endpoint = async (req, res) => {
    if (req.method !== 'POST') {
        return res.status(405).json({ 
        status: 'fail',
        message: 'Method not allowed' 
        });
    }
    await dbConnect();
    try{

        const { _id } = req.body;

        const session = await getServerSession(req, res, authOptions)

        const userId = session?.user?.userId;

        if (!userId || userId === undefined || userId === null || userId === '') {
            return res.status(400).json({ 
                status: 'fail',
                message: 'Please login to proceed' 
            });
        }

        // Delete the server
        const deletedServer = await Server.findOneAndDelete({ _id });

        return res.status(200).json({
            status: 'success',
            message: 'Server deleted fetched successfully',
        });
    }catch(err){
        console.log('Error deleting server', err);
        return res.status(500).json({
            status: 'fail',
            message: err.message || 'Failed to delete server'
        })
    }
}

export default withAdminAuth(async(req, res) => {
  await endpoint(req, res);
});