import dbConnect from '@/lib/db/dbConnect';
import { getServerSession } from 'next-auth';
import { withAdminAuth } from '../../withAdminAuth';
import { authOptions } from '../../auth/[...nextauth]';
import User from '@/lib/models/User';

const endpoint = async (req, res) => {
    if (req.method !== 'POST') {
        return res.status(405).json({ 
        status: 'fail',
        message: 'Method not allowed' 
        });
    }
    await dbConnect();
    try{

        const { name, email, isActive, password } = req.body;

        if (!email){
            return res.status(400).json({ 
                status: 'fail',
                message: 'Email is required' 
            });
        }

        const session = await getServerSession(req, res, authOptions)

        const userId = session?.user?.userId;

        if (!userId || userId === undefined || userId === null || userId === '') {
            return res.status(400).json({ 
                status: 'fail',
                message: 'Please login to proceed' 
            });
        }

        // Create the user
        const user = new User({
            name: name || '',
            email: email,
            isActive: isActive,
            // Only set password if provided
        });

        if (password && password !== '') {
            user.password = password;
        }

        await user.save();

        return res.status(200).json({
            status: 'success',
            message: 'User created successfully',
        });
    }catch(err){
        console.log('Error adding user', err);

        // Handle email uniqueness error
        if (err.code === 11000) {
            return res.status(400).json({
                status: 'fail', 
                message: 'Email already exists'
            });
        }

        return res.status(500).json({
            status: 'fail',
            message: err.message || 'Failed to create user'
        })
    }
}

export default withAdminAuth(async(req, res) => {
  await endpoint(req, res);
});