import dbConnect from '@/lib/db/dbConnect';
import { getServerSession } from 'next-auth';
import { withAdminAuth } from '../../withAdminAuth';
import { authOptions } from '../../auth/[...nextauth]';
import User from '@/lib/models/User';

const endpoint = async (req, res) => {
    if (req.method !== 'GET') {
        return res.status(405).json({ 
        status: 'fail',
        message: 'Method not allowed' 
        });
    }
    await dbConnect();
    try{

        const { type } = req.query;

        const session = await getServerSession(req, res, authOptions)

        const userId = session?.user?.userId;

        if (!userId || userId === undefined || userId === null || userId === '') {
            return res.status(400).json({ 
                status: 'fail',
                message: 'Please login to proceed' 
            });
        }

        // Fetch all orgs
        let users = [];
        if (type === 'active') {
            users = await User.find({ isActive: true })
            .sort({ createdAt: -1 });
        }
        else if (type === 'inactive') {
            users = await User.find({ isActive: false })
            .sort({ createdAt: -1 });
        }
        else {
            users = await User.find({})
            .sort({ createdAt: -1 });
        }

        return res.status(200).json({
            status: 'success',
            message: 'Users list fetched successfully',
            data: users,
        });
    }catch(err){
        console.log('Error fetching users', err);
        return res.status(500).json({
            status: 'fail',
            message: err.message || 'Failed to fetch users'
        })
    }
}

export default withAdminAuth(async(req, res) => {
  await endpoint(req, res);
});