import dbConnect from '@/lib/db/dbConnect';
import { getServerSession } from 'next-auth';
import { withAdminAuth } from '../../withAdminAuth';
import { authOptions } from '../../auth/[...nextauth]';
import User from '@/lib/models/User';

const endpoint = async (req, res) => {
    if (req.method !== 'POST') {
        return res.status(405).json({ 
        status: 'fail',
        message: 'Method not allowed' 
        });
    }
    await dbConnect();
    try{

        const { name, email, isActive, password, _id } = req.body;

        if (!email || !_id){
            return res.status(400).json({ 
                status: 'fail',
                message: 'Required parameters are missing' 
            });
        }

        const session = await getServerSession(req, res, authOptions)

        const userId = session?.user?.userId;

        if (!userId || userId === undefined || userId === null || userId === '') {
            return res.status(400).json({ 
                status: 'fail',
                message: 'Please login to proceed' 
            });
        }

        // Update the user
        const user = await User.findByIdAndUpdate(_id, {
            name: name || '',
            email: email,
            isActive: isActive,
            // Only set password if provided
            ...(password && password !== '' ? { password } : {})
        }, { new: true });

        return res.status(200).json({
            status: 'success',
            message: 'User updated successfully',
        });
    }catch(err){
        console.log('Error updating user', err);

        // Handle email uniqueness error
        if (err.code === 11000) {
            return res.status(400).json({
                status: 'fail', 
                message: 'Email already exists'
            });
        }
        
        return res.status(500).json({
            status: 'fail',
            message: err.message || 'Failed to update user'
        })
    }
}

export default withAdminAuth(async(req, res) => {
  await endpoint(req, res);
});