import dbConnect from '@/lib/db/dbConnect';
import { getServerSession } from 'next-auth';
import { withAdminAuth } from '../../withAdminAuth';
import { authOptions } from '../../auth/[...nextauth]';
import Wallet from '@/lib/models/Wallet';

const endpoint = async (req, res) => {
    if (req.method !== 'POST') {
        return res.status(405).json({ 
        status: 'fail',
        message: 'Method not allowed' 
        });
    }
    await dbConnect();
    try{
        const { orgId } = req.body;
        
        if (!orgId) {
            return res.status(400).json({ 
                status: 'fail',
                message: 'Required parameters are missing'
            });
        }

        const session = await getServerSession(req, res, authOptions)

        const userId = session?.user?.userId;

        if (!userId || userId === undefined || userId === null || userId === '') {
            return res.status(400).json({ 
                status: 'fail',
                message: 'Please login to proceed' 
            });
        }

        // Fetch the wallet balance for the organization
        const wallet = await Wallet.findOne({
            orgId: orgId,
        });

        return res.status(200).json({
            status: 'success',
            message: 'Wallet balance fetched successfully',
            balance: wallet?.balance || 0,
        });
    }catch(err){
        console.log('Error fetching wallet balance', err);
        return res.status(500).json({
            status: 'fail',
            message: err.message || 'Failed to fetch wallet balance'
        })
    }
}

export default withAdminAuth(async(req, res) => {
  await endpoint(req, res);
});