import dbConnect from '@/lib/db/dbConnect';
import { withAuth } from '../withAuth';
import { getServerSession } from 'next-auth';
import { authOptions } from '../auth/[...nextauth]';
import QR from '@/lib/models/QR';
import { checkOrgPermissions } from '@/middlewares/checkorgaccess';
import axios from 'axios';

const endpoint = async (req, res) => {
    if (req.method !== 'POST') {
        return res.status(405).json({ 
        status: 'fail',
        message: 'Method not allowed' 
        });
    }
    await dbConnect();
    try{
        const { instance_id, orgId, serverUrl } = req.body;
        if (!instance_id || !serverUrl) {
            return res.status(400).json({ 
                status: 'fail',
                message: 'Required parameters are missing'
            });
        }

        const session = await getServerSession(req, res, authOptions)

        const userId = session?.user?.userId;

        if (!userId || userId === undefined || userId === null || userId === '') {
            return res.status(400).json({ 
                status: 'fail',
                message: 'Please login to proceed' 
            });
        }

        // Post to the server to create a WhatsApp instance
        const headers = {
            'Content-Type': 'application/json',
            'x-api-key': `${process.env.SERVER_API_KEY}`
        };
        const response = await axios.post(`${serverUrl}/remove`, {
            orgId: orgId,
            userId: userId,
            instance: instance_id,
        }, {
            headers: headers
        });

        console.log('Response from server:', response.data);

        if (response.status !== 200) {
            return res.status(response.status).json({
                status: 'fail',
                message: response.data.message || 'Failed to delete WhatsApp Instance from server'
            });
        } 

        // Delete the WhatsApp instance from the database
        // const deleteResult = await QR.deleteOne({
        //     instance_id: instance_id,
        //     orgId: orgId,
        // });

        // if (deleteResult.deletedCount === 0) {
        //     return res.status(404).json({
        //         status: 'fail',
        //         message: 'WhatsApp Instance not found or you do not have permission to delete it'
        //     });
        // }

        return res.status(200).json({
            status: 'success',
            message: 'WhatsApp Instances deleted successfully',
        });
    }catch(err){
        console.log('Error deleting instance', err);
        return res.status(500).json({
            status: 'fail',
            message: err.message || 'Failed to delete WhatsApp Instance'
        })
    }
}

export default withAuth(async(req, res) => {
  const permissionsRequired = ['owner', 'write', 'admin', 'limited'];
  const orgId = req.query.orgId || req.body.orgId || req.headers['x-org-id'] || '';

  await checkOrgPermissions(permissionsRequired, orgId)(req, res, endpoint);
});