import dbConnect from '@/lib/db/dbConnect';
import User from '@/lib/models/User';
import { withAuth } from '../withAuth';
import { nanoid } from 'nanoid';
import { getServerSession } from 'next-auth';
import { authOptions } from '../auth/[...nextauth]';
import Organization from '@/lib/models/Organization';

const endpoint = async (req, res) => {
    if (req.method !== 'POST') {
        return res.status(405).json({ 
        status: 'fail',
        message: 'Method not allowed' 
        });
    }
    await dbConnect();
    try{
        const { name, description } = req.body;
        if (!name) {
            return res.status(400).json({ 
                status: 'fail',
                message: 'Organization Name is required'
            });
        }
        
        const adminEmails = ['suryavmds7000@gmail.com', 'knithishseo@gmail.com', 'sivakcr8@gmail.com', 'sendiee.web@gmail.com'];

        const session = await getServerSession(req, res, authOptions)

        const userId = session?.user?.userId;
        const userEmail = session?.user?.email;

        if (!userId || userId === undefined || userId === null || userId === '') {
            return res.status(400).json({ 
                status: 'fail',
                message: 'Please login to create an organization' 
            });
        }

        // Check if the user is an admin
        if (!adminEmails.includes(userEmail)) {
            return res.status(403).json({ 
                status: 'fail',
                message: 'You do not have permission to create an organization' 
            });
        }

        const organization = {
            name: name,
            uniqueId: nanoid(10), // Generate a unique ID for the organization
            ownerId: userId,
            description: description || '',
        }
        const orgData = await Organization.create(organization);
        const data = orgData.toObject();
        data.isOwner = true; // Set isOwner to true since the user is the creator

        return res.status(201).json({
            status: 'success',
            message: 'Organization created successfully',
            data: data
        });
    }catch(err){
        console.log('Error creating organization:', err);
        if (err.code === 11000) {
            return res.status(400).json({
                status: 'fail',
                message: 'Organization with this name already exists'
            });
        }
        return res.status(500).json({
            status: 'fail',
            message: err.message || 'Failed to create organization'
        })
    }
}

export default withAuth(async(req, res) => {
  await endpoint(req, res);
});
