import { getServerSession } from 'next-auth';
import { authOptions } from './auth/[...nextauth]';

export const withAdminAuth = handler => async (req, res) => {
    const session = await getServerSession(req, res, authOptions)

    // Check if super admin
    const isSuperAdmin = session?.user?.isSuperAdmin || false;
    
    if (!session || !isSuperAdmin) {
        return res.status(401).json({ status: 'fail', message: 'Unauthorized' });
    } 
    return handler(req, res);
};
  