/**
 * API Middleware: withAuth
 * Date: June 2025
 *
 * Description:
 *   Higher-order function to protect API routes by requiring authentication.
 *   Checks for a valid user session before allowing access to the API handler.
 *   Returns 401 Unauthorized if the user is not authenticated.
 */
import { getServerSession } from 'next-auth';
import { authOptions } from './auth/[...nextauth]';

export const withAuth = handler => async (req, res) => {
    const session = await getServerSession(req, res, authOptions)
    
    if (!session) {
        return res.status(401).json({ status: 'fail', message: 'Unauthorized' });
    } 
    return handler(req, res);
};
  