import withAuth from '@/components/auth/withAuth';
import DashboardLayout from '@/components/layout/DashboardLayout';
import PageLoading from '@/components/utils/PageLoading';
import { Button } from 'antd';
import { signOut } from 'next-auth/react';
import Head from 'next/head';
import React from 'react'

const DashboardPage = () => {
  return (
    <>
      <Head>
        <title>Create Next App</title>
        <meta name="description" content="Generated by create next app" />
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        <link rel="icon" href="/favicon.ico" />
      </Head>
      <PageLoading />
      <main>
        <DashboardLayout>
        </DashboardLayout>
      </main>
    </>
  )
}

export default withAuth(DashboardPage);