// import PageLoading from '@/components/utils/PageLoading';
import { encryptData } from '@/utils/rsaencryption';
import { Alert, Button, Divider, Form, Input, Row, message, Typography } from 'antd';
import { signIn } from 'next-auth/react';
import Head from 'next/head';
import Link from 'next/link';
import { useRouter } from 'next/router';
import React, { useState } from 'react'
import { RiEye2Line } from "react-icons/ri";
import { RiEyeCloseLine } from "react-icons/ri";
import { PiSpinnerBold } from "react-icons/pi";
import GoogleSignInButton from '@/components/auth/GoogleSignInButton';
import { MdKeyboardArrowLeft } from "react-icons/md";
import { FcGoogle } from "react-icons/fc";

const FormItem = Form.Item;
const { Text } = Typography;
 
const LoginPage = () => {
    const [messageApi, contextHolder] = message.useMessage();
    const [form] = Form.useForm();
    const [form2] = Form.useForm();
    const [formValues, setFormValues] = useState({})
    const [signupFormValues, setSignupFormValues] = useState({})
    const [isLoading, setLoading] = useState(false);
    const [isGoogleLoading, setGoogleLoading] = useState(false);
    const router = useRouter();
    const [passwordVisibility, setPasswordVisibility] = useState(false);
    const [loginMode, setLoginMode] = useState('signin'); // 'signin' or 'signup'
    const { error } = router.query;

    const handleValueChange = (e) => {
        const { name, value } = e.target;
        setFormValues({
            ...formValues,
            [name]: value
        })
    }

    const handleSignupValueChange = (e) => {
        const { name, value } = e.target;
        setSignupFormValues({
            ...signupFormValues,
            [name]: value
        })
    }

    const handleInputChange = (name, value) => {
        setFormValues({
            ...formValues,
            [name]: value
        })
    }

    const handleKeyDown = (event) => {
        if (event.key === 'Enter') {
          handleLogin();
        }
    };

    const signInGoogle = async () => {
        setGoogleLoading(true);
        try{
            const res = await signIn('google', {
                callbackUrl: '/dashboard',
                redirect: false,
            })

            if (res?.error) {
                console.error('Google Sign-In Error:', res.error);
                message.error('Failed to sign in with Google. Please try again.');
            }
        }catch(err){
            console.log(err)
        }finally {
            setGoogleLoading(false);
        }
    }

    const handleLogin = async () => {
        if (formValues.email !== '' && formValues.password !== '' && formValues.email && formValues.password) {
          setLoading(true);
          const res = await signIn('credentials', {
            email: formValues.email,
            password: encryptData(formValues.password),
            redirect: false,
          });
          setLoading(false);
          if (res.error == null) {
            router.replace('/');
          } else {
            messageApi.open({
                type: 'error',
                content: res.error,
            });
          }
        } else {
            messageApi.open({
                type: 'warning',
                content: 'Enter a valid email and password',
            });
        }
    };

    const handleSignup = async () => {
        if (signupFormValues.email !== '' && signupFormValues.password !== '' && signupFormValues.confirmpassword !== '' &&  setSignupFormValues.name &&
            signupFormValues.email && signupFormValues.password && signupFormValues.confirmpassword && signupFormValues.name) {
            if (signupFormValues.password !== signupFormValues.confirmpassword) {
                messageApi.open({
                    type: 'warning',
                    content: 'Passwords do not match',
                });
                return;
            }
            // Proceed with signup
            if (signupFormValues.password.length < 6) {
                messageApi.open({
                    type: 'warning',
                    content: 'Password must be at least 6 characters long',
                });
                return;
            }
            if (!/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(signupFormValues.email)) {
                messageApi.open({
                    type: 'warning',
                    content: 'Please enter a valid email address',
                });
                return;
            }
            setLoading(true);
            const res = await signIn('credentials', {
                email: signupFormValues.email,
                password: encryptData(signupFormValues.password),
                name: signupFormValues.name,
                redirect: false,
                isSignup: true
            });
            setLoading(false);
            if (res.error == null) {
                router.replace('/');
            } else {
                messageApi.open({
                    type: 'error',
                    content: res.error,
                });
            }
        } else {
            messageApi.open({
                type: 'warning',
                content: 'Enter a valid email and password',
            });
        }
    }

  return (
    <>
    <Head>
        <title>Login - Sendiee</title>
        <meta name="description" content="" />
    </Head>
    {contextHolder}
    {/* <PageLoading /> */}
    <main>
        <div className='login_page'>
            <div className='login_background'></div>
            <div className='login_container'>
                <div>
                    <Link href="/" className="back_to_home">
                        <Button style={{padding: '0px'}} type='link' icon={<MdKeyboardArrowLeft />}>Back to home</Button>
                    </Link>
                </div>
                <div className="login_mode_select">
                    <div className={`mode_button ${loginMode === 'signin' ? 'active' : ''}`} onClick={() => setLoginMode('signin')}>
                        Sign In
                    </div>
                    <div className={`mode_button ${loginMode === 'signup' ? 'active' : ''}`} onClick={() => setLoginMode('signup')}>
                        Create New Account
                    </div>
                </div>
                {
                    loginMode === 'signup' ? 
                    <div className='mode_signup_container'>
                        <Alert type='warning' message="To create new account, please contact +91 89460 42821"/>
                        {/* <Form form={form2} onFinish={handleSignup}>
                            <FormItem name='name_s' rules={[{ required: true, message: 'Please enter your name' }]}>
                                <Input 
                                    name='name'
                                    size='large'
                                    autoComplete='name'
                                    maxLength={50}
                                    showCount
                                    value={signupFormValues.name}
                                    placeholder='Full Name'
                                    onChange={handleSignupValueChange}
                                />
                            </FormItem>
                            <FormItem name='email_s' rules={[{ required: true, message: 'Please enter your email address' }]}>
                                <Input 
                                    name='email'
                                    size='large'
                                    type='email'
                                    autoComplete='email'
                                    autoFocus
                                    value={signupFormValues.email}
                                    placeholder='Email address'
                                    onChange={handleSignupValueChange}
                                />
                            </FormItem>
                            <FormItem name='password_s' rules={[{ required: true, message: 'Please enter your password' }]}>
                                <Input 
                                    name='password'
                                    size='large'
                                    autoComplete='current-password'
                                    type={passwordVisibility ? 'text' : 'password'}
                                    value={signupFormValues.password}
                                    placeholder='Password'
                                    onChange={handleSignupValueChange}
                                    suffix={
                                        <span className='password_toggle' onClick={() => setPasswordVisibility(!passwordVisibility)}>
                                            {!passwordVisibility ? <RiEyeCloseLine /> : <RiEye2Line />}
                                        </span>
                                    }
                                />
                            </FormItem>
                            <FormItem name='confirmpassword' rules={[{ required: true, 
                                    validateTrigger: 'onBlur',
                                    validator: (_, value) => {
                                        if (!value || value === signupFormValues.password) {
                                            return Promise.resolve();
                                        }
                                        return Promise.reject(new Error('Passwords do not match'));
                                    }
                             }]}>
                                <Input 
                                    name='confirmpassword'
                                    size='large'
                                    value={signupFormValues.confirmpassword}
                                    placeholder='Retype Password'
                                    onChange={handleSignupValueChange}
                                />
                            </FormItem>
                            <FormItem>
                                <Button 
                                    type='primary' 
                                    htmlType='submit'
                                    block
                                    size='large'
                                    className={`login_button ${isLoading ? 'loading' : ''}`}
                                    loading={isLoading}
                                >
                                    Sign Up
                                </Button>
                            </FormItem>
                        </Form> */}
                    </div> : 
                    <div className='mode_login_container'>
                        <Form form={form} onFinish={handleLogin} onKeyDown={handleKeyDown}>
                            <FormItem name='email' rules={[{ required: true, message: 'Please enter your email address' }]}>
                                <Input 
                                    name='email'
                                    size='large'
                                    type='email'
                                    autoComplete='email'
                                    autoFocus
                                    value={formValues.email}
                                    placeholder='Email address'
                                    onChange={handleValueChange}
                                />
                            </FormItem>
                            <FormItem name='password' rules={[{ required: true, message: 'Please enter your password' }]}>
                                <Input 
                                    name='password'
                                    size='large'
                                    autoComplete='current-password'
                                    autoFocus
                                    type={passwordVisibility ? 'text' : 'password'}
                                    value={formValues.password}
                                    placeholder='Password'
                                    onChange={handleValueChange}
                                    suffix={
                                        <span className='password_toggle' onClick={() => setPasswordVisibility(!passwordVisibility)}>
                                            {!passwordVisibility ? <RiEyeCloseLine /> : <RiEye2Line />}
                                        </span>
                                    }
                                />
                            </FormItem>
                            <FormItem>
                                <Button 
                                    type='primary' 
                                    htmlType='submit'
                                    block
                                    size='large'
                                    className={`login_button ${isLoading ? 'loading' : ''}`}
                                    loading={isLoading}
                                >
                                    Sign In
                                </Button>
                            </FormItem>
                        </Form>
                    </div>
                }

                <Divider className='divider'>OR</Divider>

                <Button loading={isGoogleLoading} onClick={() => signInGoogle()} block size='large' icon={<FcGoogle />}>
                    Continue with Google
                </Button>

                {error && <Alert 
                    message={error}
                    type="error"
                    showIcon
                />}

                <div className='login_footer'>
                    <p>
                        By signing in to Sendiee, you agree to our <Link href="/terms">Terms of Service</Link> and <Link href="/privacy">Privacy Policy</Link>.
                    </p>
                </div>
            </div>
        </div>
    </main>
    </>
  )
}

export default LoginPage