import moment from 'moment';
import momentTimeZone from 'moment-timezone';

export const formatDate = (dateString) => {
  const utcDate = moment.utc(dateString);
  const istDate = utcDate.tz('Asia/Kolkata'); // Convert to IST  // America/Toronto
  const timeZoneAbbr = 'IST'; // Hardcode IST abbreviation
  
  return `${istDate.format('DD-MM-YYYY HH:mm')} ${timeZoneAbbr}`;
  // return `${istDate.format('DD-MMM-YYYY HH:mm:ss')} ${timeZoneAbbr}`;
};