export function formatMilliCurrency(amount) {
    if (typeof amount !== 'number' || isNaN(amount)) {
        return '$0.00';
    }
    // Show up to 5 decimals, but trim trailing zeros
    const formattedAmount = (parseFloat(amount) / 1000).toFixed(5).replace(/\.?0+$/, '');
    return `$${formattedAmount}`;
}