// Select Consistent Avatar Based on Unique String
export const getRandomAvatar = (u) => {
    const avatars = [
        '/avatars/avatar1.jpg',
        '/avatars/avatar2.jpg',
        '/avatars/avatar3.jpg',
        '/avatars/avatar4.jpg',
    ];

    if (!u) {
        // No input provided, return random
        return avatars[Math.floor(Math.random() * avatars.length)];
    }

    // Simple hash function
    let hash = 0;
    for (let i = 0; i < u.length; i++) {
        hash = u.charCodeAt(i) + ((hash << 5) - hash);
    }

    // Ensure positive index and map to avatar
    const index = Math.abs(hash) % avatars.length;
    return avatars[index];
};