import crypto from 'crypto';

// Read keys from environment variables
const PUBLIC_KEY = process.env.NEXT_PUBLIC_PUBLIC_KEY.replace(/\\n/g, '\n');

/**
 * Encrypts the given text using RSA public key encryption.
*
* @param {string} text - The plain text to encrypt.
* @returns {string} The encrypted text in base64 format.
*/
export const encryptData = (text) => {
    const buffer = Buffer.from(text, 'utf8');
    const encrypted = crypto.publicEncrypt(PUBLIC_KEY, buffer);
    return encrypted.toString('base64');
};

/**
 * Decrypts the given encrypted text using RSA private key decryption.
*
* @param {string} encryptedText - The encrypted text in base64 format.
* @returns {string} The decrypted plain text.
*/
export const decryptData = (encryptedText) => {
    const PRIVATE_KEY = process.env.PRIVATE_KEY.replace(/\\n/g, '\n');
    const buffer = Buffer.from(encryptedText, 'base64');
    const decrypted = crypto.privateDecrypt(
        {
        key: PRIVATE_KEY,
        passphrase: process.env.PASSPHRASE,
        },
        buffer
    );
    return decrypted.toString('utf8');
};
